-- hook API functions

local oldPickupMacro=PickupMacro;
local oldPickupContainerItem=PickupContainerItem;
local oldPickupInventoryItem=PickupInventoryItem;
local oldPickupSpell=PickupSpell;
local oldPickupAction=PickupAction;
local oldPlaceAction=PlaceAction;
local oldUseAction=UseAction;
local oldGetActionText=GetActionText;
local oldGetActionTexture=GetActionTexture;

function PickupMacro(macroid, supername)
	if ( supername ) then
		SM_CURSOR=supername;
		-- 查找一个可用的临时宏ID，避免使用最大宏数量限制
		local tempMacroId = nil;
		local originalName, originalIcon = nil, nil;
		local tempicon=SM_MACRO_ICON[GetSuperMacroInfo(supername,"texture")];
		
		-- 首先尝试查找一个已存在的宏ID（从18开始往下找）
		for i = 18, 1, -1 do
			local name = GetMacroInfo(i);
			if (name) then
				tempMacroId = i;
				originalName, originalIcon = GetMacroInfo(tempMacroId);
				break;
			end
		end
		
		-- 如果没有找到已存在的宏，尝试查找一个可用的ID来创建临时宏
		if (not tempMacroId) then
			for i = 1, 18 do
				local name = GetMacroInfo(i);
				if (not name) then
					tempMacroId = i;
					break;
				end
			end
		end
		
		if (tempMacroId) then
			-- 如果这个宏ID存在，临时修改它的图标
			if (originalName) then
				EditMacro(tempMacroId, originalName, tempicon);
			else
				-- 如果不存在，尝试创建一个临时宏
				local success = pcall(CreateMacro, "TempSM", tempicon or 132365, "", nil, 1);
				if (not success) then
					-- 如果创建失败（宏数量已满），使用第一个宏
					tempMacroId = 1;
					originalName, originalIcon = GetMacroInfo(tempMacroId);
					EditMacro(tempMacroId, originalName or "", tempicon);
				end
			end
			
			-- 拾取这个临时宏
			oldPickupMacro(tempMacroId);
			
			-- 恢复原始宏的设置
			if (originalName) then
				EditMacro(tempMacroId, originalName, SM_MACRO_ICON[originalIcon]);
			else
				-- 如果是临时创建的，尝试删除它
				pcall(DeleteMacro, tempMacroId);
			end
		else
			-- 如果无法找到可用的宏ID，使用默认行为
			oldPickupMacro(macroid or 1);
		end
	else
		SM_CURSOR=nil;
		oldPickupMacro(macroid or 1);
	end
end

function PickupContainerItem(index, slot)
	SM_CURSOR=nil;
	oldPickupContainerItem(index, slot);
end

function PickupInventoryItem(index)
	SM_CURSOR=nil;
	oldPickupInventoryItem(index);
end

function PickupSpell(index, book)
	SM_CURSOR=nil;
	oldPickupSpell(index, book);
end

function PickupAction(id)
	if ( SM_ACTION[id] ) then
		SM_CURSOR=SM_ACTION[id];
		-- 查找一个可用的临时宏ID，避免使用最大宏数量限制
		local tempMacroId = nil;
		local originalName, originalIcon = nil, nil;
		local tempicon=SM_MACRO_ICON[GetSuperMacroInfo(SM_CURSOR,"texture")];
		
		-- 首先尝试查找一个已存在的宏ID（从18开始往下找）
		for i = 18, 1, -1 do
			local name = GetMacroInfo(i);
			if (name) then
				tempMacroId = i;
				originalName, originalIcon = GetMacroInfo(tempMacroId);
				break;
			end
		end
		
		-- 如果没有找到已存在的宏，尝试查找一个可用的ID来创建临时宏
		if (not tempMacroId) then
			for i = 1, 18 do
				local name = GetMacroInfo(i);
				if (not name) then
					tempMacroId = i;
					break;
				end
			end
		end
		
		if (tempMacroId) then
			-- 如果这个宏ID存在，临时修改它的图标
			if (originalName) then
				EditMacro(tempMacroId, originalName, tempicon);
			else
				-- 如果不存在，尝试创建一个临时宏
				local success = pcall(CreateMacro, "TempSM", tempicon or 132365, "", nil, 1);
				if (not success) then
					-- 如果创建失败（宏数量已满），使用第一个宏
					tempMacroId = 1;
					originalName, originalIcon = GetMacroInfo(tempMacroId);
					EditMacro(tempMacroId, originalName or "", tempicon);
				end
			end
			
			SM_ACTION[id]=nil;
			oldPickupAction(id);
			
			-- 恢复原始宏的设置
			if (originalName) then
				EditMacro(tempMacroId, originalName, SM_MACRO_ICON[originalIcon]);
			else
				-- 如果是临时创建的，尝试删除它
				pcall(DeleteMacro, tempMacroId);
			end
		else
			-- 如果无法找到可用的宏ID，使用默认行为
			SM_ACTION[id]=nil;
			oldPickupAction(id);
		end
	else
		SM_CURSOR=nil;
		SM_ACTION[id]=nil;
		oldPickupAction(id or 1);
	end
end


function PlaceAction(id)
	-- place and pickup super
	local cursor;
	if ( SM_ACTION[id] ) then
		cursor=SM_ACTION[id];
	end
	SM_ACTION[id]=SM_CURSOR;
	SM_CURSOR=cursor;
	oldPlaceAction(id or 1);
end

function UseAction( id, click, selfcast)
	lastActionUsed = id;
	if ( SuperMacroFrame_SaveMacro and SuperMacroFrame:IsVisible() ) then
		SuperMacroFrame_SaveMacro();
	end
	if ( SM_ACTION[id] ) then
		RunSuperMacro(SM_ACTION[id]);
	elseif ( GetActionText(id) ) then
		RunMacro(GetActionText(id));
	else
		oldUseAction( id, click, selfcast );
	end
end

function GetActionText(id)
	if ( SM_ACTION[id] ) then
		return SM_ACTION[id];
	else
		return oldGetActionText(id);
	end
end

function GetActionTexture(id)
	if ( SM_ACTION[id] ) then
		local texture=GetSuperMacroInfo(SM_ACTION[id], "texture");
		return texture;
	else
		return oldGetActionTexture(id);
	end
end

function SuperMacro_UpdateAction(oldsuper, newsuper)
	for k,v in SM_ACTION do
		if v==oldsuper then
			SM_ACTION[k]=newsuper;
		end
	end
end

function SetActionSuperMacro(actionid, supername)
	if ( supername and actionid > 0 and actionid <= 120 ) then
		PickupAction( actionid );
		PickupMacro(nil, supername );
		PlaceAction ( actionid );
	end
end

function SM_ActionButton_OnClick()
	if ( SM_CURSOR ) then
		PlaceAction(ActionButton_GetPagedID(this));
		ActionButton_UpdateState();
		return 1;
	end
end